﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Net.Http;

namespace DeX_Demo_Jun21
{
    public class StudentLoad : BaseCall
    {
        public static HttpClient httpClient = new HttpClient();
        #region Bits to support DeX OData
        /// <summary>
        /// Base URL for DeX
        /// </summary>
        public const string URLBase = "https://seli00apm01.azure-api.net/dex//";
        /// <summary>
        /// A simple device to format the URL and cope with version changes
        /// </summary>
        /// <param name="Service"></param>
        /// <param name="Call"></param>
        /// <returns></returns>
        private static string SetURL(string Service, string Call)
        {
           // <Base>\staff/odata/v3/StaffPersonalBasics
           return URLBase + string.Format("{0}/odata/V3/{1}", Service, Call);
        }
        /// <summary>
        /// This function is included to get around an initial bug 
        /// however, once fixed the 'bad' url won't occur and 
        /// </summary>
        /// <param name="nextLink"></param>
        /// <returns></returns>
        public static string GetNextLink(string nextLink)
        {
            string bad = "https://sims8live01.westeurope.cloudapp.azure.com:8443";
            if (nextLink.StartsWith(bad))
            {
                string[] bits = nextLink.Split('/');
                string service = bits[3].Substring(0, bits[3].IndexOf("servicefarm1"));
                string call = bits[6];

                //https://sims8live01.westeurope.cloudapp.azure.com:8443/learnerservicefarm1/odata/v3/LearnerPersonals?$select=ExternalID%2CDateOfBirth&$skip=1000
                // https://seli00apm01.azure-api.net/dex/Learner/odata/V3/LearnerPersonals?$select=ExternalID,DateOfBirth
                // https://seli00apm01.azure-api.net/dex/learnerservicefarm1/odata/v3/LearnerPersonals?$select=ExternalID%2CDateOfBirth&$skip=1000
                // https://seli00apm01.azure-api.net/dex/learnerservicefarm1/odata/v3/LearnerPersonals?$select=ExternalID%2CDateOfBirth&$skip=1000
                string s = SetURL(service, call);
                return s;
            }
            return nextLink;
        }
        #endregion
        #region Contact Basics - we need this to fill in some info about a contact
        public class ContactBasics_Response
        {
            public Guid ExternalID;
            public string Surname;
            public string Forename;
            public string MiddleName;
            public string Salutation;
            public string Addressee;
            public Lookup Title;
            public Lookup Gender;
            

        }
        #region Contact Links
        public static Dictionary<Guid, C_Response> C_Values = new Dictionary<Guid, C_Response>();
        private static void LoadCs()
        {
            string URL_ContactDetails = SetURL("Learner", "ContactContactDetails?$expand=Emails,LearnerRelationships,Addresses,Telephones");
            string resp = DoCall(URL_ContactDetails, callInfo.bearerToken.Token, httpClient, callInfo.arq.OCP_APIM_Key);
            ODataResponse<C_Response> contacts = null;
            try
            {
                contacts = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<C_Response>>(resp);
                foreach (C_Response s in contacts.Value)
                {
                    C_Values.Add(s.ExternalID, s);
                }
                // Very likely > 1000
                while (!string.IsNullOrEmpty(contacts.NextLink))
                {
                    resp = DoCall(GetNextLink(contacts.NextLink), callInfo.bearerToken.Token, httpClient, callInfo.arq.OCP_APIM_Key);
                    contacts = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<C_Response>>(resp);
                    foreach (C_Response s in contacts.Value)
                    {
                        C_Values.Add(s.ExternalID, s);
                    }
                }
            }
            catch
            {
                ErrorMessage = "Error: " + resp;
            }

        }

        public class C_Response
        {
            public Guid ExternalID;
            public string Salutation;
            public List<AddressRecords> Addresses;
            public List<LearnerRelationships> LearnerRelationships;
            public List<Email> Emails;
            public List<Telephone> Telephones;

        }
        public class Telephone
        {
            public Guid ExternalID;
            public string TelephoneNumber;
            public Nullable<bool> UseForAutomatedMessages;
        }
        public class Email
        {
            public Guid ExternalID;
            public string EmailAddress;
            public Nullable<bool> IsMainEmail;
            public Nullable<bool> UseForAutomatedMessages;
        }
        public class AddressRecords
        {
            public Guid ExternalID;
            public Nullable<DateTime> StartDate;
            public Nullable<DateTime> EndDate;
            public Address Address;
        }
        public class Address
        {
            public Guid ExternalID;
            public string Apartment;
            public string BuildingNumber;
            public string BuildingName;
            public string Street;
            public string District;
            public string Town;
            public string AdministrativeArea;
            public string Postcode;
            public string AddressIdentifier;
        }
        public class LearnerRelationships
        {
            public Guid ExternalID;
            public Nullable<bool> HasCourtOrder;
            public Nullable<bool> HasParentalResponsibility;
            public string Priority; // Possibly should be an int but it makes no difference in this case
            public Lookup Learner;
        }
        #endregion
        #region Registration
        // Learner Reg
        //*AdmissionNumber
        //UPN
        public class LR_Response
        {
            public Guid ExternalID;
            public string AdmissionNumber;
            public string UniquePupilNumber;
        }
        public static Dictionary<Guid, LR_Response> LR_Values = new Dictionary<Guid, LR_Response>();
        private static void LoadLRs()
        {
            LR_Values.Clear();
            string URL_LearnerRegistration = SetURL("Learner", "LearnerRegistrations?$select=ExternalID,AdmissionNumber,UniquePupilNumber&");
            string resp = DoCall(URL_LearnerRegistration, callInfo.bearerToken.Token, httpClient, callInfo.arq.OCP_APIM_Key);
            ODataResponse<LR_Response> learners = null;
            try
            {
                learners = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<LR_Response>>(resp);
                foreach (LR_Response s in learners.Value)
                {
                    LR_Values.Add(s.ExternalID, s);
                }
                // Very likely > 1000
                while (!string.IsNullOrEmpty(learners.NextLink))
                {
                    resp = DoCall(GetNextLink(learners.NextLink), callInfo.bearerToken.Token, httpClient, callInfo.arq.OCP_APIM_Key);
                    learners = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<LR_Response>>(resp);
                    foreach (LR_Response s in learners.Value)
                    {
                        LR_Values.Add(s.ExternalID, s);
                    }
                }
            }
            catch
            {
                ErrorMessage = "Error: " + resp;
            }

        }

        #endregion
        #region Lookups
        public static Dictionary<Guid, BaseLookup> Ethnicities = new Dictionary<Guid, BaseLookup>();
        public static Dictionary<Guid, BaseLookup> Religions = new Dictionary<Guid, BaseLookup>();
        public class BaseLookup
        {
            public Guid ExternalID;
            public string Type;
            public string Description;
            // Get the values for lookups;
            public static void GetValues(ref Dictionary<Guid, BaseLookup> values, string URL)
            {
                values.Clear();
                string resp = DoCall(URL, callInfo.bearerToken.Token, httpClient, callInfo.arq.OCP_APIM_Key);
                ODataResponse<BaseLookup> lookups = null;
                try
                {
                    lookups = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<BaseLookup>>(resp);
                    foreach (BaseLookup s in lookups.Value)
                    {
                        values.Add(s.ExternalID, s);
                    }
                    // Very unlikely  > 1000
                    while (!string.IsNullOrEmpty(lookups.NextLink))
                    {
                        resp = DoCall(GetNextLink(lookups.NextLink), callInfo.bearerToken.Token, httpClient, callInfo.arq.OCP_APIM_Key);
                        lookups = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<BaseLookup>>(resp);
                        foreach (BaseLookup s in lookups.Value)
                        {
                            values.Add(s.ExternalID, s);
                        }
                    }
                }
                catch (Exception ex)
                {
                    ErrorMessage = "Error: " + resp;
                }

            }
        }
        public static string ReligionURL = "LearnerLookups?$filter=LookupType eq 'Religion'&$select=ExternalID,LookupType,Description";
        public static string EthicityURL = "LearnerLookups?$filter=LookupType eq 'Ethnicity'&$select=ExternalID,LookupType,Description";
        #endregion
        #region Identifiers
        // Learner Identifier
        //* Surname
        //*ChosenName
        //* group_code(Year)
        //*RegGroup
        //*Gender
        public class LI_Response
        {
            public Guid ExternalID;
            public string Forename;
            public string Surname;
            public string GenderCategory;
            public string OnRollState;
            public Lookup CurrentYearGroup;
            public Lookup CurrentPrimaryClass;
        }
        public static Dictionary<Guid, LI_Response> LI_Values = new Dictionary<Guid, LI_Response>();
        private static void LoadLIs()
        {
            LI_Values.Clear();
            string URL_LearnerIdentifier = SetURL("Learner", "LearnerIdentifiers?$filter=OnRollState eq 'Current'&$select=ExternalID,Forename,Surname,GenderCategory,OnRollState,CurrentYearGroup,CurrentPrimaryClass&");
            // URL_LearnerIdentifier = SetURL("Learner", "LearnerIdentifiers?$select=ExternalID,Forename,Surname,GenderCategory,OnRollState,CurrentYearGroup,CurrentPrimaryClass&");
            string resp = DoCall(URL_LearnerIdentifier, callInfo.bearerToken.Token, httpClient, callInfo.arq.OCP_APIM_Key);
            ODataResponse<LI_Response> learners = null;
            try
            {
                learners = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<LI_Response>>(resp);
                foreach (LI_Response s in learners.Value)
                {
                    LI_Values.Add(s.ExternalID, s);
                }
                // Very likely > 1000
                while (!string.IsNullOrEmpty(learners.NextLink))
                {
                    resp = DoCall(GetNextLink(learners.NextLink), callInfo.bearerToken.Token, httpClient, callInfo.arq.OCP_APIM_Key);
                    learners = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<LI_Response>>(resp);
                    foreach (LI_Response s in learners.Value)
                    {
                        LI_Values.Add(s.ExternalID, s);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorMessage = "Error: " + resp;
            }

        }
        #endregion
        #region Cultural
        //Religion
        //Ethnicity

        public class LC_Response
        {
            public Guid ExternalID;
            public Lookup Ethnicity;
            public Lookup Religion;
        }
        public static Dictionary<Guid, LC_Response> LC_Values = new Dictionary<Guid, LC_Response>();

        private static void LoadLCs()
        {
            C_Values.Clear();
            string URL_LearnerCultural = SetURL("Learner", "LearnerCulturals?$select=ExternalID,Ethnicity,Religion&");
            string resp = DoCall(URL_LearnerCultural, callInfo.bearerToken.Token, httpClient, callInfo.arq.OCP_APIM_Key);
            ODataResponse<LC_Response> learners = null;
            try
            {
                learners = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<LC_Response>>(resp);
                foreach (LC_Response s in learners.Value)
                {
                    LC_Response lc = new LC_Response();
                    lc.ExternalID = s.ExternalID;
                    BaseLookup lu = null;
                    bool add = false;
                    if (s.Ethnicity != null)
                    {
                        if (Ethnicities.TryGetValue(s.Ethnicity.ExternalID, out lu))
                        {
                            lc.Ethnicity = new Lookup();
                            lc.Ethnicity.ExternalID = lu.ExternalID;
                            lc.Ethnicity.Description = lu.Description;
                            add = true;
                        }
                    }
                    if (s.Religion != null)
                    {
                        if (Religions.TryGetValue(s.Religion.ExternalID, out lu))
                        {

                            lc.Religion = new Lookup();
                            lc.Religion.ExternalID = lu.ExternalID;
                            lc.Religion.Description = lu.Description;
                            add = true;
                        }
                    }
                    if (add)
                    {
                        LC_Values.Add(lc.ExternalID, lc);
                    }
                }
                // Very likely > 1000
                while (!string.IsNullOrEmpty(learners.NextLink))
                {
                    resp = DoCall(GetNextLink(learners.NextLink), callInfo.bearerToken.Token, httpClient, callInfo.arq.OCP_APIM_Key);
                    learners = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<LC_Response>>(resp);
                    foreach (LC_Response s in learners.Value)
                    {
                        LC_Response lc = new LC_Response();
                        lc.ExternalID = s.ExternalID;
                        BaseLookup lu = null;
                        bool add = false;
                        if (s.Ethnicity != null)
                        {
                            if (Ethnicities.TryGetValue(s.Ethnicity.ExternalID, out lu))
                            {
                                lc.Ethnicity = new Lookup();
                                lc.Ethnicity.ExternalID = lu.ExternalID;
                                lc.Ethnicity.Description = lu.Description;
                                add = true;
                            }
                        }
                        if (s.Religion != null)
                        {
                            if (Religions.TryGetValue(s.Religion.ExternalID, out lu))
                            {

                                lc.Religion = new Lookup();
                                lc.Religion.ExternalID = lu.ExternalID;
                                lc.Religion.Description = lu.Description;
                                add = true;
                            }
                        }
                        if (add)
                        {
                            LC_Values.Add(lc.ExternalID, lc);
                        }
                    }
                }
            }
            catch
            {
                ErrorMessage = "Error: " + resp;
            }

        }
        #endregion
        #region Personal
        // Learner Personal
        //* DateOfBirth

        public class LP_Response
        {
            public Guid ExternalID;
            public Nullable<DateTime> DateOfBirth;
        }
        public static Dictionary<Guid, Nullable<DateTime>> LP_Values = new Dictionary<Guid, DateTime?>();
        private static void LoadLPs()
        {
            LP_Values.Clear();
            string URL_LearnerPersonal = SetURL("Learner", "LearnerPersonals?$select=ExternalID,DateOfBirth");
            string resp = DoCall(URL_LearnerPersonal, callInfo.bearerToken.Token, httpClient, callInfo.arq.OCP_APIM_Key); ;
            try
            {
                ODataResponse<LP_Response> learnerPs = null;
                learnerPs = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<LP_Response>>(resp);
                // Need to be able to lookup 
                foreach (LP_Response p in learnerPs.Value)
                {
                    LP_Values.Add(p.ExternalID, p.DateOfBirth);
                }
                // Probable that there are >1000 kids
                while (!string.IsNullOrEmpty(learnerPs.NextLink))
                {
                    resp = DoCall(GetNextLink(learnerPs.NextLink), callInfo.bearerToken.Token, httpClient, callInfo.arq.OCP_APIM_Key);
                    learnerPs = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<LP_Response>>(resp);
                    foreach (LP_Response p in learnerPs.Value)
                    {
                        if (!LP_Values.ContainsKey(p.ExternalID))
                        {
                            LP_Values.Add(p.ExternalID, p.DateOfBirth);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorMessage = "Error: " + resp;
                return;
            }
        }
        #endregion
        #region Dietary
        // Learner Dietary
        //free_meal
        //free_meal_start
        //free_meal_end
        //Diet
        public class LD_Response
        {
            public Guid ExternalID;
            public List<Lookup> DietaryNeeds;
            public List<DateRange> FreeMealEligibilityPeriods;
        }
        public static Dictionary<Guid, LD_Response> LD_Values = new Dictionary<Guid, LD_Response>();

        private static void LoadLDs()
        {
            LD_Values.Clear();
            string URL_LearnerDietary = SetURL("Learner", "LearnerDietarys?$expand=DietaryNeeds,FreeMealEligibilityPeriods");
            string resp = DoCall(URL_LearnerDietary, callInfo.bearerToken.Token, httpClient, callInfo.arq.OCP_APIM_Key);
            ODataResponse<LD_Response> learners = null;
            try
            {
                learners = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<LD_Response>>(resp);
                foreach (LD_Response s in learners.Value)
                {
                    LD_Values.Add(s.ExternalID, s);
                }
                // Very likely > 1000
                while (!string.IsNullOrEmpty(learners.NextLink))
                {
                    resp = DoCall(GetNextLink(learners.NextLink), callInfo.bearerToken.Token, httpClient, callInfo.arq.OCP_APIM_Key);
                    learners = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<LD_Response>>(resp);
                    foreach (LD_Response s in learners.Value)
                    {
                        LD_Values.Add(s.ExternalID, s);
                    }
                }
            }
            catch
            {
                ErrorMessage = "Error: " + resp;
            }

        }
        #endregion
        #region Common
        public class Lookup
        {
            public Guid ExternalID;
            public string Description;
        }
        public class DateRange
        {
            public Guid ExternalID;
            public Nullable<DateTime> StartDate;
            public Nullable<DateTime> EndDate;

        }

        #endregion
        public static string ErrorMessage = "";
        public static PostitCommon.CallInfo callInfo = null;
        public static string BaseURL = "";
        public static void Run(ref Dictionary<string, XStudent> Collection, PostitCommon.CallInfo _callInfo)
        {
            callInfo = _callInfo;
            #region Load
            // Load Religion / Enthnic lookups
            BaseLookup.GetValues(ref Religions, SetURL("Learner", ReligionURL));
            BaseLookup.GetValues(ref Ethnicities, SetURL("Learner", EthicityURL));
            // Want LearnerPersonals to get DOB
            LoadLPs();
            // Want Learner Indentifiers
            LoadLIs();
            // Want culturals
            LoadLCs();
            // Load Learner Dietarys
            LoadLDs();
            // Load Learner Reg
            LoadLRs();
            // Load Contacts
            LoadCs();

            #endregion
            Collection.Clear();
            Dictionary<Guid, XStudent> students = new Dictionary<Guid, XStudent>();
            LoadS(ref students);
            // OK this is 2 copies of students but when we process parents, we will need to duplicate the student info
            JoinItAllUp(ref Collection, ref students);
        }
        public static void JoinItAllUp(ref Dictionary<string, XStudent> Collection, ref Dictionary<Guid, XStudent> students)
        {
            foreach (C_Response c in C_Values.Values)
            {
                XStudent xs = null;
                string key = "";
                Address xa = null;
                string xEmail = "";
                string xPhone = "";
                if (c.LearnerRelationships != null)
                {
                    // Process the addresses and get one
                    if (c.Addresses != null)
                    {
                        foreach (AddressRecords a in c.Addresses)
                        {
                            if (a.StartDate != null &&
                                a.StartDate <= DateTime.Today &&
                                (a.EndDate == null ||
                                a.EndDate >= DateTime.Today)
                                )
                            {
                                xa = a.Address;
                                break;
                            }

                        }
                    }
                    // Now need a contact email
                    if (c.Emails != null)
                    {
                        foreach (Email em in c.Emails)
                        {
                            if (em.UseForAutomatedMessages == true)
                            {
                                xEmail = em.EmailAddress;
                                break;
                            }
                        }
                    }
                    // Now need a contact phone number
                    if (c.Telephones != null)
                    {
                        foreach (Telephone t in c.Telephones)
                        {
                            if (t.UseForAutomatedMessages == true)
                            {
                                xPhone = t.TelephoneNumber;
                                break;
                            }
                        }
                    }
                    foreach (LearnerRelationships lr in c.LearnerRelationships)
                    {
                        // Guid of parent | Student
                        key = c.ExternalID.ToString() + "|" + lr.Learner.ExternalID.ToString();
                        if (students.TryGetValue(lr.Learner.ExternalID, out xs))
                        {
                            xs.Salutation = c.Salutation;
                            if (xa != null)
                            {
                                xs.AdministrativeArea = xa.AdministrativeArea;
                                xs.Apartment = xa.Apartment;
                                xs.BuildingName = xa.BuildingName;
                                xs.District = xa.District;
                                xs.Postcode = xa.Postcode;
                                xs.Street = xa.Street;
                                xs.Town = xa.Town;
                                xs.BuildingNumber = xa.BuildingNumber;
                            }
                            xs.ContactEmail = xEmail;
                            xs.ContactMobile = xPhone;
                        }
                        if (key != "" && xs != null)
                        {
                            Collection.Add(key, xs);
                        }
                    }
                }

            }

        }

        public static void LoadS(ref Dictionary<Guid, XStudent> students)
        {
            foreach (LI_Response l in LI_Values.Values)
            {
                XStudent s = new XStudent();
                // Build from Identifiers - these are filtered to current.
                {
                    s.ExternalID = l.ExternalID;
                    s.Gender = l.GenderCategory;
                    s.Surname = l.Surname;
                    s.ChosenName = l.Forename;
                    s.CurrentPrimaryClass = "";
                    s.CurrentYearGroup = "";
                    if (l.CurrentPrimaryClass != null)
                    {
                        s.CurrentPrimaryClass = l.CurrentPrimaryClass.Description;
                    }
                    if (l.CurrentYearGroup != null)
                    {
                        s.CurrentYearGroup = l.CurrentYearGroup.Description;
                    }
                }
                // Add In DOB from Learner Personal
                {
                    Nullable<DateTime> lp = null;
                    if (LP_Values.TryGetValue(s.ExternalID, out lp))
                    {
                        s.DateOfBirth = lp;
                    }
                }
                // Add in Culturals
                {
                    LC_Response lc = null;
                    if (LC_Values.TryGetValue(s.ExternalID, out lc))
                    {
                        if (lc.Ethnicity != null)
                        {
                            s.Ethnicity = lc.Ethnicity.Description;
                        }
                        if (lc.Religion != null)
                        {
                            s.Religion = lc.Religion.Description;
                        }
                    }
                }
                // Add in Dietaries
                {
                    LD_Response lc = null;
                    if (LD_Values.TryGetValue(s.ExternalID, out lc))
                    {
                        s.free_meal_start = null;
                        s.free_meal_end = null;

                        foreach (DateRange d in lc.FreeMealEligibilityPeriods)
                        {
                            // Take the latest
                            if (s.free_meal_start == null || s.free_meal_start < d.StartDate)
                            {
                                s.free_meal_start = d.StartDate;
                                s.free_meal_end = d.EndDate;
                            }
                        }
                        s.Diet = "";
                        foreach (Lookup lu in lc.DietaryNeeds)
                        {
                            if (s.Diet != "")
                            {
                                s.Diet += ",";
                            }
                            if (lu != null && lu.Description != null)
                                s.Diet += (lu.Description.Replace("\"", "'").Replace(",", ";"));
                        }
                    }

                }
                // Add in Registraions
                {
                    LR_Response lc = null;
                    if (LR_Values.TryGetValue(s.ExternalID, out lc))
                    {
                        s.UPN = lc.UniquePupilNumber;
                        s.AdmissionNumber = lc.AdmissionNumber;
                    }

                }
                students.Add(s.ExternalID, s);
            }
        }
    }
}
